/**********************************************************************
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : tbsutil.h
 ļ : TBS ߷


 ޶¼ :
          1  : TBS
             : 2007-11-14
             : ںа˫
          2 ޸ : Ժ
             : 2008-9-3
             : ԭ˫ϵͳͷļͻ޸Ķͻ

**********************************************************************/

#ifndef __TBS_UTIL_H__
#define __TBS_UTIL_H__

#define _GNU_SOURCE
#include "autoconf.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include "tbstype.h"
#include "common.h"



/* նʹõɫ */
#define ECHO_NONE           "\033[0m"

#define ECHO_RED            "\033[0;31m"
#define ECHO_GREEN          "\033[0;32m"
#define ECHO_YELLOW         "\033[0;33m"
#define ECHO_BLUE           "\033[0;34m"
#define ECHO_PURPLE         "\033[0;35m"

/* ˸ */
#define ECHO_FLASH_RED      "\033[5;31m"
#define ECHO_FLASH_GREEN    "\033[5;32m"
#define ECHO_FLASH_YELLOW   "\033[5;33m"
#define ECHO_FLASH_BLUE     "\033[5;34m"
#define ECHO_FLASH_PURPLE   "\033[5;35m"


#define MAX_IP_LIST_LEN (16 * MAX_IP_COUNT)
#define MAX_IP_COUNT 30

#define MAX_MAC_LIST_LEN (18 * MAX_MAC_COUNT)
#define MAX_MAC_COUNT   30
#define MAX_USER_LEN    32      /* û/볤 */

#define PATH_MAC_ADDRESS  "/proc/llconfig/macaddr"
#define MAX_VALUE_OF_HEX   0xFFFFFF
#define CYCLE_VALUE_OF_HEX  0x1000000

#define URL_STR_URL_MAX_LEN       256       /* URLַ*/

enum
{
	MAC_LAN_DEVICE = 0,
	MAC_WAN_DEVICE,
};


/* macַ */
typedef struct tag_ST_MAC_Addr
{
	unsigned char addr[6];
} ST_MAC_Addr;


/******************************************************************************
 *                                 λ                                   *
 ******************************************************************************/
#define SET_BIT(flag, bit)		(flag)|=(bit)
#define CLEAR_BIT(flag,bit)		(flag)&=~(bit)
#define TEST_BIT(flag,bit)		(flag)&(bit)

/******************************************************************************
 *                                 ָ                                   *
 ******************************************************************************/
#define	SAFE_FREE(ptr)	free(ptr);ptr=NULL

#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))
#define ALIGN(x,a) (((x)+(a)-1)&~((a)-1))
#define FIELD_SIZEOF(t, f) (sizeof(((t*)0)->f))

/******************************************************************************
 *                                 IP                                   *
 ******************************************************************************/
#define NET_ADDR(ip, mask)              ((ip) & (mask))
#define HOST_ADDR(ip, mask)             ((ip) & ~(mask))

#define IS_NET_ADDR(ip, mask)           (HOST_ADDR(ip, mask) == 0)
#define IS_BROAD_ADDR(ip, mask)         (HOST_ADDR(ip, mask) == ~(mask))
#define IN_SAME_SUBNET(ip1, ip2, mask)  (NET_ADDR(ip1, mask) == NET_ADDR(ip2, mask))
#define IN_NOTSAME_SUBNET(ip1, ip2, mask)  (NET_ADDR(ip1, mask) != NET_ADDR(ip2, mask))



#ifndef _SYS_QUEUE_H
/*
   TBSԭ˫<sys/queue.h> егͻ
   ޸TBS˫ز壬ǰTBSǰ׺
   Ϊ˲Ӱģ飬û<sys/queue.h>ʱת
   ԺģҪʹôTBSǰ׺Ĳ
*/
#define list_head       TBS_list_head
#define ST_LIST_HEAD    TBS_ST_LIST_HEAD
#define LIST_HEAD_INIT  TBS_LIST_HEAD_INIT
#define LIST_HEAD       TBS_LIST_HEAD
#define INIT_LIST_HEAD  TBS_INIT_LIST_HEAD
#define __list_add      TBS__list_add
#define list_add        TBS_list_add
#define list_add_tail   TBS_list_add_tail
#define __list_del      TBS__list_del
#define list_del        TBS_list_del
#define list_empty      TBS_list_empty
#define list_entry      TBS_list_entry
#define list_for_each   TBS_list_for_each
#define list_for_each_safe   TBS_list_for_each_safe
#define list_splice     TBS_list_splice

#endif
/******************************************************************************
 *                                 ˫                                   *
 ******************************************************************************/

/*
 * Simple doubly linked list implementation.
 *
 * Some of the internal functions ("__xxx") are useful when
 * manipulating whole lists rather than single entries, as
 * sometimes we already know the next/prev entries and we can
 * generate better code by using them directly rather than
 * using the generic single-entry routines.
 */

struct TBS_list_head {
    struct TBS_list_head *next, *prev;
};

typedef struct TBS_list_head TBS_ST_LIST_HEAD;  /* ǵ淶 */

#define TBS_LIST_HEAD_INIT(name) { &(name), &(name) }

#define TBS_LIST_HEAD(name) \
    struct TBS_list_head name = TBS_LIST_HEAD_INIT(name)

static inline void TBS_INIT_LIST_HEAD(TBS_ST_LIST_HEAD *list)
{
    list->next = list;
    list->prev = list;
}

/*
 * Insert a new entry between two known consecutive entries.
 *
 * This is only for internal list manipulation where we know
 * the prev/next entries already!
 */
static inline void TBS__list_add(TBS_ST_LIST_HEAD *new,
                              TBS_ST_LIST_HEAD *prev, TBS_ST_LIST_HEAD *next)
{
    next->prev = new;
    new->next = next;
    new->prev = prev;
    prev->next = new;
}

/**
 * list_add - add a new entry
 * @new: new entry to be added
 * @head: list head to add it after
 *
 * Insert a new entry after the specified head.
 * This is good for implementing stacks.
 */
static inline void TBS_list_add(TBS_ST_LIST_HEAD *new, TBS_ST_LIST_HEAD *head)
{
    TBS__list_add(new, head, head->next);
}

/**
 * list_add_tail - add a new entry
 * @new: new entry to be added
 * @head: list head to add it before
 *
 * Insert a new entry before the specified head.
 * This is useful for implementing queues.
 */
static inline void TBS_list_add_tail(TBS_ST_LIST_HEAD *new, TBS_ST_LIST_HEAD *head)
{
    TBS__list_add(new, head->prev, head);
}

/*
 * Delete a list entry by making the prev/next entries
 * point to each other.
 *
 * This is only for internal list manipulation where we know
 * the prev/next entries already!
 */
static inline void TBS__list_del(TBS_ST_LIST_HEAD *prev, TBS_ST_LIST_HEAD *next)
{
    next->prev = prev;
    prev->next = next;
}

/**
 * list_del - deletes entry from list.
 * @entry: the element to delete from the list.
 * Note: list_empty on entry does not return true after this, the entry is
 * in an undefined state.
 */
static inline void TBS_list_del(TBS_ST_LIST_HEAD *entry)
{
    TBS__list_del(entry->prev, entry->next);
    TBS_INIT_LIST_HEAD(entry);
}

/**
 * list_empty - tests whether a list is empty
 * @head: the list to test.
 */
static inline int TBS_list_empty(const TBS_ST_LIST_HEAD *head)
{
    return head->next == head;
}

/**
 * TBS_list_one_node - tests whether a list has only one node
 * @head: the list to test
 */
static inline int TBS_list_one_node(const TBS_ST_LIST_HEAD *head)
{
    return head->next->next == head;
}

/**
 * list_entry - get the struct for this entry
 * @ptr:	the &TBS_ST_LIST_HEAD pointer.
 * @type:	the type of the struct this is embedded in.
 * @member:	the name of the list_struct within the struct.
 */
#define TBS_list_entry(ptr, type, member) \
	((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))

/**
 * list_for_each	-	iterate over a list
 * @pos:	the &TBS_ST_LIST_HEAD to use as a loop cursor.
 * @head:	the head for your list.
 */
#define TBS_list_for_each(pos, head) \
	for (pos = (head)->next; pos != (head); pos = pos->next)


/**
 * list_for_each_safe    -    iterate over a list safe against removal of list entry
 * @pos:    the &struct list_head to use as a loop counter.
 * @n:        another &struct list_head to use as temporary storage
 * @head:    the head for your list.
 */
#define TBS_list_for_each_safe(pos, n, head) \
        for (pos = (head)->next, n = pos->next; pos != (head); \
            pos = n, n = pos->next)

/**
 * list_splice - join two lists
 * @list: the new list to add.
 * @head: the place to add it in the first list.
 */
static inline void TBS_list_splice(TBS_ST_LIST_HEAD *list, TBS_ST_LIST_HEAD *head)
{
    TBS_ST_LIST_HEAD *first = list->next;

    if (first != list) {
        TBS_ST_LIST_HEAD *last = list->prev;
        TBS_ST_LIST_HEAD *at = head->next;

        first->prev = head;
        head->next = first;

        last->next = at;
        at->prev = last;
    }
}

/**
 * TBS_list_node_count - count list node number
 * @head: the list to count
 */
static inline int TBS_list_node_count(const TBS_ST_LIST_HEAD *head)
{
    TBS_ST_LIST_HEAD *plhPos = NULL;
    int i = 0;

    TBS_list_for_each(plhPos, head)
    {
        i++;
    }

    return i;
}

/******************************************************************************
 *                                 ַ                                 *
 ******************************************************************************/
extern char *strndup(const char *s, size_t n);
static inline int safe_strcmp(const char *s1, const char *s2)
{
    if (!s1 && !s2)
        return 0;
    if (!s1)
        return -1;
    if (!s2)
        return 1;
    return strcmp(s1, s2);
}

static inline int safe_strncmp(const char *s1, const char *s2, int n)
{
    if (!s1 && !s2)
        return 0;
    if (!s1)
        return -1;
    if (!s2)
        return 1;
    return strncmp(s1, s2, n);
}

static inline char *safe_strstr(const char *s1, const char *s2)
{
    if (!s1 || !s2)
        return NULL;
    return strstr(s1, s2);
}

static inline int safe_strlen(const char *s)
{
    if (!s)
        return 0;
    return strlen(s);
}

static inline int safe_atoi(const char *s)
{
    if (!s)
        return 0;
    return atoi(s);
}

static inline long safe_atol(const char *s)
{
    if (!s)
        return 0;
    return atol(s);
}

static inline unsigned long safe_atoul(const char *s)
{
    if (!s)
        return 0;
    return strtoul(s, NULL, 10);
}

static inline char * safe_strncpy(char *dst, const char *src, size_t size)
{
	if (!size) return dst;
	dst[--size] = '\0';
	return strncpy(dst, src, size);
}

size_t strlcpy(char *dst, const char *src, size_t siz);

size_t strlcat(char* dst, const char* src, size_t siz);



/******************************************************************************
 *                                ͨù߷                                *
 ******************************************************************************/

/*ַƥ亯*/
BOOL tbsMatch(const char *pszString, const char *pszPattern);

/* tbsSystemӡ */
#if 1
    #define TBS_PRINT_CMD       1
#else
    #define TBS_PRINT_CMD       0
#endif

/* ϵͳsystemķװ */
int tbsSystem(char *command, int printFlag);

#define tbsSystemMute(cmd)  tbsSystem(cmd, 0)

/*ַIPת޷ųIP*/
unsigned long tbsCnvtIpFromStr(const char *pcIp);

/* ַתmacṹ */
ST_MAC_Addr *tbsCnvtMacFromStr(const char *pszMac, ST_MAC_Addr *pstMac);

/* MACṹתΪַ */
void tbsCnvtMacToStr(ST_MAC_Addr *pstMac, char *pszMac);

/* IPַǷһΧ֮ */
int tbsCheckIpRange(const char *pStartIp, const char *pEndIp);

/* ipmaskǷƥ */
int tbsCheckIpMask(const char *pszIp, const char *pszMask);

/*IPתΪַIP*/
void tbsCnvtIpToStr(unsigned long ulIp, char *pszIp);

/*ַ"1""true"ִСдתBOOLͣ*/
BOOL tbsStrToBool(const char *pcValue);

/* 1ĸ,Ƿ򷵻ظ */
int tbsGetBitsByMask(const char *pcMask);


/* ַַָָ */
int tbsSplitString(char *str, char *substr[], const char delimit, const int max_count);

/*
ƶַָбַ
(: xx,yy,zz, ָ֮{xx, yy, zz})
*/
int tbsStrListSplit(char *strList, char delimit, char *apcStrArray[], int nMaxCnt);

/*
һбַвһԪ
(: xx,yy,zz, yy)
*/
int tbsStrListFind(const char *szList, char delimit, const char *szEntry);

/*
һбַһԪ
(: xx,yy, zz,  xx,yy,zz)
*/
int tbsStrListAdd(char *szList, char delimit, const char *szEntry);

/*
һбַɾһԪ
(: xx,yy,zz, ɾyy,  xx,zz)
*/
int tbsStrListDel(char *szList, char delimit, const char *szDel);

void TW_printf(const void *buf, int len);

/*=========================================================================*/
/*                                                                                                                                                                    */
/*                                     ϼ麯Ϊ˰汾ݱ                                                  */
/*                                                                                                                                                                    */
/*=========================================================================*/

/* IPϷ */
BOOL tbsCheckIp(const char *pcip);

BOOL tbsCheckPort(const char *pszString);

int tbsCheckAvailablePort(const char *pszProto, const char *pszSrcPort, const char *pszEndPort);

BOOL tbsCheckPriority(const char *pszString);


/*Ϸ*/
BOOL tbsCheckMask(const char *pcValue);



/* BOOL ֵĺϷ*/
BOOL tbsCheckEnable(const char *pszValue);

/* int ֵĺϷ*/
BOOL tbsCheckInt(const char *pszValue);

/* unsigned int ֵĺϷ*/
BOOL tbsCheckUInt(const char *pszValue);

/*MACַϷ*/
BOOL tbsCheckMac(const char *pcMac);



/* IPб */
BOOL tbsCheckIpList(const char *pszIpList, int iMaxCount);

/* MAC б*/
BOOL tbsCheckMacList(const char *pszMacList, int iMaxCount);

/*=========================================================================*/
/*                                                                                                                                                                    */
/*                                     ¼麯ֵıΪʽ                                 */
/*                                                                                                                                                                    */
/*=========================================================================*/

/*
ʹôʽƥҪֵ,ƥ򷵻ָĴ
*/
int tbsCheckRegex(const char *pszValue, const char *pszPattern, int iErrNo);


/* IPϷ */
int tbsCheckIpEx(const char *pszValue);
int tbsCheckHostIpEx(const char *pszValue);

int tbsCheckPortEx(const char *pszString);

int tbsCheckPriorityEx(const char *pszString);

/* Ϸ */
int tbsCheckMaskEx(const char *pcValue);

/* IPĳͻ */
int tbsCheckConflictIpMask(const char *pszIp, const char *pszMask);

/* BOOL ֵĺϷ*/
int tbsCheckEnableEx(const char *pszValue);

/* int ֵĺϷ*/
int tbsCheckIntEx(const char *pszValue);

/* unsigned int ֵĺϷ*/
int tbsCheckUIntEx(const char *pszValue);

/* intֵǷָΧ */
int tbsCheckIntRangeEx(const char *pszValue, int nMin, int nMax);

/* uintֵǷָΧ */
int tbsCheckUIntRangeEx(const char *pszValue, unsigned int nMin, unsigned int nMax);


/*MACַϷ*/
int tbsCheckMacEx(const char *pcMac);

/* IPб */
int tbsCheckIpListEx(const char *pszIpList, int iMaxCount);
int tbsCheckHostIpListEx(const char *pszIpList, int iMaxCount);

/* IPǷͬһ*/
int Check2IpIsInSameNet(const char *pcIp1,const char *pcIp2,const char *mask);


/* MAC б*/
int tbsCheckMacListEx(const char *pszMacList, int iMaxCount);

/* û/ */
int tbsCheckUserEx(const char *pszValue);
int tbsCheckUserExWithLength(const char *pszValue, const int iLen);
int tbsCheckPasswdEx(const char *pszValue);
int tbsCheckPasswdExWithLength(const char *pszValue, const int iLen);

/* ʽǷϷ */
int tbsCheckDomainName(const char *pszValue);

/* IPĺϷ */
int tbsCheckHost(const char *pszValue);

/* urlϷ*/
int tbsCheckUrl(const char * pValue);


/*********************************************************************
*  : tbsAddMac

*  : macַ֧LANWAN豸޸

*  : pIfNameΪ豸,eth0
		 iInterfaceTypeΪMAC_LAN_DEVICEMAC_WAN_DEVICE
		 szMacVal  ظߵmacַ, ڴɵ

*  : TBS_SUCCESS/TBS_FAILED

*  : zhujianwen / 2008-12-25
*********************************************************************/
int tbsAddMac(const char *pIfName, int iInterfaceType, char *szMacVal);


/* DNSصAPIṹ,Ķ */
#define IP_LEN  46

/* Ž֮IPַԪ */
typedef struct ST_DNS_INFO
{
	char szIp[IP_LEN];
	struct ST_DNS_INFO* pNext;
}ST_DNS_INFO;

enum
{
	SPLIT_ERROR		= -1,		/* ʧ */
	SPLIT_SUCCESS	= 0,		/* ɹ */
	SPLIT_IP		= 1,		/* IPַ */
	SPLIT_IP6		= 2,		/* IPv6ַ */
};

/* , ҪԼ˿ں */
int tbsSplitUrl(const char *pUrl, char *pHostName, char *pPort, char *pPath);

/* Դн, ST_DNS_INFO */
int	tbsResolveIpByName(const char *pszUrl, ST_DNS_INFO** ppDnsInfo,
						char* pPort, int nMsecond, const char* pServer);

/* ST_DNS_INFO, ͷԪ */
void tbsFreeDnsInfo(ST_DNS_INFO* pDnsInfo);

/* ԴʹָĽӿںdnsн,  */
int tbsResolveURL(const char *pszUrl, const char *pszIfName, const char *pszGateway, const char *pszDnsServers,
    char *pcIpAddr, char *pcPort);




/* ̰߳ȫstrtokʵ, net-snmp-5.4.1Ŀ */
char * Strtok_r(char *pString, const char *pDelim, char **pLast);

/* ַ滻ܺ(·ڴ) */
char* tbsStringReplaceWithMalloc(const char *pcSrc, const char *pcOldStr, const char *pcNewStr);

/* ַ滻ܺ(滻ԭַ) */
char* tbsStringReplace(char *pcSrc, const char *pcOldStr, const char *pcNewStr);



/*
ļȡһ, صַҪûͷ
*/
int tbsReadFileWithMalloc(const char *pcFileName, unsigned long nPadLen,
        char **ppBuf, unsigned long *pnLen);

/*
ļȡһ, ͻûָ, ȡȵļ
*/
int tbsReadFile(const char *pcFileName, char *pcBuf, unsigned long *pnLen);

/*
ָȵд뵽ָļ
*/
int tbsWriteFile(const char *pcFileName, char *pcBuf, unsigned long nLen);


/*
ָļвַ
*/
int tbsFindStrInFile(const char *pszFileName, const char *pszStr);





/**************************************************************************
  : ethernet WANӿƻȡӿڵЭ(λMbps)

  : pszDevName -- ethernet WANӿ(eth0)

ֵ: ethernet WANӿڵЭ

  ע: created by XuXiaodong 2009-3-18
***************************************************************************/
int tbsGetEthWanIfLinkSpeed(const char *pszDevName);

enum
{
	TR069_UPGRADE,
	WEB_UPGRADE
};

/* ڴ */
void tbsClearRamForUpgrade(int iUpgradeFlag);

/* ýǱΪػ */
int tbsDaemonize(int closefd);

/* /õǰ̱ʱcoreļ */
int tbsEnableCoreDump(int iFlag);

/* ַͨת16ַ */
int tbsSting2Hex(char *szSrcString, char *szDecHex, unsigned int i2Num);

/* ͨӿȡӿڶӦMACַ */
int tbsGetMacAddr(const char *pszIfName, char *pszMac);

/* ȡϵͳʱ䣬λΪ */
long tbsGetSysUpTime();

#ifdef CONFIG_TBS_SUPPORT_IPV6
/* ЭǷϷ*/
int tbsCheckProtoType(const char * pszValue);
#endif

/* ȡlogicʱ䣬λΪ */
long tbsGetLogicUpTime();



/*=========================================================================
*
*    Mem Pool function
*
*=========================================================================*/

/*********************************************************************
*  : ڴ,¼
*********************************************************************/
void *Mem_Malloc(size_t nSize, const char *szFile, const char *szFunc, unsigned long ulLine);

/*********************************************************************
*  : Ϊڴ(ڴ0),¼
*********************************************************************/
void *Mem_Calloc(size_t nMemb, size_t nSize, const char *szFile, const char *szFunc, unsigned long ulLine);

/*********************************************************************
*  : ·ڴ( ͷ/չԭڴ),¼
*********************************************************************/
void *Mem_Realloc(void *pAddr, size_t nSize, const char *szFile, const char *szFunc, unsigned long ulLine);

/*********************************************************************
*  : ͷڴ,ɾ¼
*********************************************************************/
void Mem_Free(void *pAddr, const char *szFile, const char *szFunc, unsigned long ulLine);

/*********************************************************************
*  : ͷڴ, ɾм¼
*********************************************************************/
void Mem_FreeAll(void);

/*********************************************************************
*  : ʾ֮δͷŵڴ
*********************************************************************/
void Mem_PrintStatus(void);

/*********************************************************************
*  : ʾ֮δͷŵڴ(Ѿô˺ʾڴ鲻ʾ)
*********************************************************************/
void Mem_PrintStatusOnce(void);

/*********************************************************************
*  : ַ
*********************************************************************/
char *Mem_Strdup(const char *pcStr, const char *szFile, const char *szFunc, unsigned long ulLine);
char *Mem_Strndup(const char *pcStr, size_t nSize, const char *szFile, const char *szFunc, unsigned long ulLine);

/* ضmallocڴ亯,ڴй© */
#ifdef CONFIG_TBS_APPS_DEBUG_MALLOC
#define tbsMalloc(size)            Mem_Malloc(size, __FILE__, __func__, __LINE__)
#define tbsCalloc(nmemb, size)     Mem_Calloc(nmemb, size, __FILE__, __func__, __LINE__)
#define tbsRealloc(p, size)        Mem_Realloc(p, size, __FILE__, __func__, __LINE__)
#define tbsFree(p)                 Mem_Free(p, __FILE__, __func__, __LINE__)
#define tbsStrdup(str)             Mem_Strdup(str, __FILE__, __func__, __LINE__)
#define tbsStrndup(str, size)      Mem_Strndup(str, size, __FILE__, __func__, __LINE__)

#define malloc      tbsMalloc
#define calloc      tbsCalloc
#define realloc     tbsRealloc
#define free        tbsFree
#define strdup      tbsStrdup
#define strndup     tbsStrndup

#endif

#ifdef CONFIG_APPS_LOGIC_PHY_WIFI_MODE
char WLAN_GetWifiMode();
#endif
int GetModelName(char *ModelName);
int  tbsStrToLower(char *s);



/*=========================================================================
*
*    Crypt function: MD5/BASE64
*
*=========================================================================*/
char *MD5_Binary(unsigned char *buf, int length);
char *MD5_String(char *string);


int CalcNonce(char **nonce);
int CalcDigest(char *userName, char *password, char *realm, char *uri,
                char *nonce, char *qop, char *nc, char *cnonce, char *method,
                char **digest);

char *Base64_Encode(const char* input, const int inputlen);
char *Base64_Decode(const char* input, const int inputlen);
int Safe_Base64Decode(char *pStrIn, char *pStrOut);
int Safe_Base64Encode(char *pStrIn, char *pStrOut);


//transform string to uppercase
 char *tbsStrToUpper(const char *s);
char *StrSkip(char src[],char remove);
void tbsLowercaseToUppercase(char *pstr);
#endif                          /* __TBS_UTIL_H__ */
